<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Inspection System')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
        }
        .sidebar .nav-link {
            color: rgba(255,255,255,.8);
            padding: 0.75rem 1rem;
        }
        .sidebar .nav-link:hover {
            color: #fff;
            background: rgba(255,255,255,.1);
        }
        .sidebar .nav-link.active {
            color: #fff;
            background: rgba(255,255,255,.2);
        }
        .sidebar .nav-link i {
            margin-right: 0.5rem;
        }
        .content-wrapper {
            min-height: 100vh;
            background: #f8f9fa;
        }
        .card-stats {
            border-left: 4px solid;
        }
        .card-stats.primary { border-left-color: #0d6efd; }
        .card-stats.success { border-left-color: #198754; }
        .card-stats.danger { border-left-color: #dc3545; }
        .card-stats.warning { border-left-color: #ffc107; }
        .badge-status {
            font-size: 0.875rem;
            padding: 0.35em 0.65em;
        }
    </style>
    @stack('styles')
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <nav class="col-md-3 col-lg-2 d-md-block sidebar collapse px-0">
                <div class="p-3">
                    <a href="/" class="text-white text-decoration-none">
                        <h5><i class="bi bi-clipboard-check"></i> Inspection System</h5>
                    </a>
                </div>
                <hr class="text-white-50 mx-3">
                <ul class="nav flex-column">
                    @if(auth()->user()->isAdmin())
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" href="{{ route('admin.dashboard') }}">
                                <i class="bi bi-speedometer2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }}" href="{{ route('admin.users.index') }}">
                                <i class="bi bi-people"></i> Users
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.departments.*') ? 'active' : '' }}" href="{{ route('admin.departments.index') }}">
                                <i class="bi bi-building"></i> Departments
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.checklists.*') ? 'active' : '' }}" href="{{ route('admin.checklists.index') }}">
                                <i class="bi bi-list-check"></i> Checklists
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.equipment.*') ? 'active' : '' }}" href="{{ route('admin.equipment.index') }}">
                                <i class="bi bi-tools"></i> Equipment
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.inspections.*') ? 'active' : '' }}" href="{{ route('admin.inspections.index') }}">
                                <i class="bi bi-file-earmark-text"></i> Inspections
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.settings.*') ? 'active' : '' }}" href="{{ route('admin.settings.index') }}">
                                <i class="bi bi-gear"></i> Settings
                            </a>
                        </li>
                    @else
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('worker.dashboard') ? 'active' : '' }}" href="{{ route('worker.dashboard') }}">
                                <i class="bi bi-speedometer2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('worker.inspections.select-checklist') ? 'active' : '' }}" href="{{ route('worker.inspections.select-checklist') }}">
                                <i class="bi bi-plus-circle"></i> New Inspection
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('worker.inspections.index') ? 'active' : '' }}" href="{{ route('worker.inspections.index') }}">
                                <i class="bi bi-file-earmark-text"></i> My Inspections
                            </a>
                        </li>
                    @endif
                </ul>
                <hr class="text-white-50 mx-3">
                <div class="px-3 text-white-50 small">
                    <div class="mb-2">
                        <i class="bi bi-person"></i> {{ auth()->user()->full_name }}
                    </div>
                    <div class="mb-2">
                        <span class="badge {{ auth()->user()->isAdmin() ? 'bg-danger' : 'bg-primary' }}">
                            {{ ucfirst(auth()->user()->role) }}
                        </span>
                    </div>
                    <form action="{{ route('logout') }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-outline-light btn-sm w-100">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </button>
                    </form>
                </div>
            </nav>

            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 content-wrapper">
                <div class="py-4">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @yield('content')
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    @stack('scripts')
</body>
</html>
