<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>New Inspection Report</title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333;">
    <div style="max-width: 600px; margin: 0 auto; padding: 20px;">
        <h2 style="color: #333; border-bottom: 2px solid #0066cc; padding-bottom: 10px;">
            New Inspection Report Submitted
        </h2>
        
        <p>A new equipment inspection has been submitted. Here are the details:</p>
        
        <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
            <tr>
                <td style="padding: 8px; border-bottom: 1px solid #ddd; font-weight: bold; width: 40%;">Worker:</td>
                <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{ $inspection->user->full_name }}</td>
            </tr>
            <tr>
                <td style="padding: 8px; border-bottom: 1px solid #ddd; font-weight: bold;">Employee ID:</td>
                <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{ $inspection->user->employee_id }}</td>
            </tr>
            <tr>
                <td style="padding: 8px; border-bottom: 1px solid #ddd; font-weight: bold;">Equipment:</td>
                <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{ $inspection->equipment->name }} ({{ $inspection->equipment->tag_id }})</td>
            </tr>
            <tr>
                <td style="padding: 8px; border-bottom: 1px solid #ddd; font-weight: bold;">Checklist:</td>
                <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{ $inspection->checklist->title }}</td>
            </tr>
            <tr>
                <td style="padding: 8px; border-bottom: 1px solid #ddd; font-weight: bold;">Date/Time:</td>
                <td style="padding: 8px; border-bottom: 1px solid #ddd;">{{ $inspection->inspection_date->format('M d, Y H:i:s') }}</td>
            </tr>
            <tr>
                <td style="padding: 8px; border-bottom: 1px solid #ddd; font-weight: bold;">Status:</td>
                <td style="padding: 8px; border-bottom: 1px solid #ddd;">
                    <span style="padding: 3px 8px; border-radius: 3px; font-weight: bold; 
                        {{ $inspection->overall_status === 'passed' ? 'background: #d4edda; color: #155724;' : 'background: #f8d7da; color: #721c24;' }}">
                        {{ strtoupper($inspection->overall_status) }}
                    </span>
                </td>
            </tr>
        </table>
        
        <p style="margin-top: 20px;">
            <a href="{{ $url }}" style="display: inline-block; padding: 10px 20px; background: #0066cc; color: #fff; text-decoration: none; border-radius: 5px;">
                View Full Report
            </a>
        </p>
        
        <p style="color: #666; font-size: 12px; margin-top: 30px; border-top: 1px solid #ddd; padding-top: 15px;">
            This is an automated notification from the Inspection System.
        </p>
    </div>
</body>
</html>
