@extends('layouts.app')

@section('title', 'Pending Users')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-clock"></i> Pending Users</h2>
    <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left"></i> Back to Users
    </a>
</div>

@if($users->isEmpty())
    <div class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-check-circle text-success" style="font-size: 3rem;"></i>
            <h4 class="mt-3">No Pending Users</h4>
            <p class="text-muted">All user registrations have been processed.</p>
        </div>
    </div>
@else
    @foreach($users as $user)
        <div class="card mb-3">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-md-8">
                        <h5>{{ $user->full_name }}</h5>
                        <p class="mb-1">
                            <strong>Username:</strong> {{ $user->username }} |
                            <strong>Employee ID:</strong> {{ $user->employee_id }}
                        </p>
                        <p class="mb-1">
                            <strong>Email:</strong> {{ $user->email }} |
                            <strong>Department:</strong> {{ $user->department->name }}
                        </p>
                        <p class="text-muted mb-0">
                            <small>Registered: {{ $user->created_at->format('M d, Y H:i') }}</small>
                        </p>
                    </div>
                    <div class="col-md-4">
                        <form action="{{ route('admin.users.approve', $user) }}" method="POST">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label">Assign Checklists</label>
                                <select name="checklists[]" class="form-select" multiple size="3">
                                    @foreach($checklists as $checklist)
                                        <option value="{{ $checklist->id }}">{{ $checklist->title }}</option>
                                    @endforeach
                                </select>
                                <small class="text-muted">Hold Ctrl to select multiple</small>
                            </div>
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-success flex-grow-1">
                                    <i class="bi bi-check"></i> Approve
                                </button>
                            </div>
                        </form>
                        <form action="{{ route('admin.users.reject', $user) }}" method="POST" class="mt-2">
                            @csrf
                            <button type="submit" class="btn btn-danger w-100" onclick="return confirm('Are you sure?')">
                                <i class="bi bi-x"></i> Reject
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endforeach

    {{ $users->links() }}
@endif
@endsection
