@extends('layouts.app')

@section('title', 'Equipment')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-tools"></i> Equipment</h2>
    <a href="{{ route('admin.equipment.create') }}" class="btn btn-primary">
        <i class="bi bi-plus"></i> Add Equipment
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Tag ID</th>
                        <th>Department</th>
                        <th>Location</th>
                        <th>Type</th>
                        <th>Checklists</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($equipment as $equip)
                        <tr>
                            <td>{{ $equip->name }}</td>
                            <td><code>{{ $equip->tag_id }}</code></td>
                            <td>{{ $equip->department->name }}</td>
                            <td>{{ $equip->location }}</td>
                            <td>{{ $equip->getTypeLabel() }}</td>
                            <td>{{ $equip->checklists->count() }}</td>
                            <td>
                                <span class="badge {{ $equip->is_active ? 'bg-success' : 'bg-secondary' }}">
                                    {{ $equip->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>
                                <a href="{{ route('admin.equipment.edit', $equip) }}" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="{{ route('admin.equipment.destroy', $equip) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger" 
                                            onclick="return confirm('Are you sure?')">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        {{ $equipment->links() }}
    </div>
</div>
@endsection
