<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class InspectionItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'inspection_id',
        'checklist_item_id',
        'result',
        'fail_description',
    ];

    public function inspection(): BelongsTo
    {
        return $this->belongsTo(Inspection::class);
    }

    public function checklistItem(): BelongsTo
    {
        return $this->belongsTo(ChecklistItem::class);
    }

    public function photos(): HasMany
    {
        return $this->hasMany(InspectionPhoto::class);
    }

    public function getResultLabel(): string
    {
        return match($this->result) {
            'ok' => 'OK',
            'fail' => 'Failed',
            'na' => 'N/A',
            default => 'Unknown',
        };
    }

    public function getResultClass(): string
    {
        return match($this->result) {
            'ok' => 'success',
            'fail' => 'danger',
            'na' => 'secondary',
            default => 'secondary',
        };
    }
}
