#!/bin/bash

# Inspection System Setup Script

echo "=========================================="
echo "Inspection System - Setup Script"
echo "=========================================="
echo ""

# Check PHP version
if ! command -v php &> /dev/null; then
    echo "❌ PHP not found. Please install PHP 8.2+"
    exit 1
fi

PHP_VERSION=$(php -v | grep -oP '\d+\.\d+' | head -1)
echo "✓ PHP $PHP_VERSION found"

# Check Composer
if ! command -v composer &> /dev/null; then
    echo "❌ Composer not found. Please install Composer"
    exit 1
fi

echo "✓ Composer found"
echo ""

# Install dependencies
echo "Installing dependencies..."
composer install

# Copy env file
if [ ! -f .env ]; then
    cp .env.example .env
    echo "✓ .env file created"
else
    echo "✓ .env file already exists"
fi

# Generate app key
echo "Generating app key..."
php artisan key:generate

# Create directories
mkdir -p storage/logs
mkdir -p storage/framework/cache
mkdir -p storage/framework/sessions
mkdir -p bootstrap/cache

echo ""
echo "=========================================="
echo "Setup Complete!"
echo "=========================================="
echo ""
echo "Next steps:"
echo "1. Edit .env with your database credentials"
echo "2. Run: php artisan migrate"
echo "3. Run: php artisan serve"
echo ""
echo "Default login:"
echo "  Username: admin"
echo "  Password: admin123"
echo ""
