@extends('layouts.app')

@section('title', 'Perform Inspection')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-clipboard-check"></i> Perform Inspection</h2>
    <a href="{{ route('worker.inspections.select-equipment', $checklist) }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left"></i> Back
    </a>
</div>

<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <h6 class="text-muted mb-1">Checklist</h6>
                <h5 class="mb-0">{{ $checklist->title }}</h5>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <h6 class="text-muted mb-1">Equipment</h6>
                <h5 class="mb-0">{{ $equipment->name }} ({{ $equipment->tag_id }})</h5>
            </div>
        </div>
    </div>
</div>

<form action="{{ route('worker.inspections.store', [$checklist, $equipment]) }}" method="POST" enctype="multipart/form-data">
    @csrf

    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Inspection Items</h5>
        </div>
        <div class="card-body">
            @foreach($checklist->items as $item)
                <div class="border rounded p-3 mb-3">
                    <div class="row align-items-start">
                        <div class="col-md-6">
                            <h6 class="mb-1">{{ $item->item_name }}</h6>
                            @if($item->description)
                                <p class="text-muted small mb-2">{{ $item->description }}</p>
                            @endif
                            @if($item->require_description_on_fail)
                                <span class="badge bg-warning text-dark">Description required if failed</span>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <div class="mb-2">
                                <div class="btn-group w-100" role="group">
                                    <input type="radio" class="btn-check" name="items[{{ $item->id }}][result]" 
                                           id="item{{ $item->id }}_ok" value="ok" checked>
                                    <label class="btn btn-outline-success" for="item{{ $item->id }}_ok">
                                        <i class="bi bi-check-circle"></i> OK
                                    </label>

                                    <input type="radio" class="btn-check" name="items[{{ $item->id }}][result]" 
                                           id="item{{ $item->id }}_fail" value="fail">
                                    <label class="btn btn-outline-danger" for="item{{ $item->id }}_fail">
                                        <i class="bi bi-x-circle"></i> Fail
                                    </label>

                                    <input type="radio" class="btn-check" name="items[{{ $item->id }}][result]" 
                                           id="item{{ $item->id }}_na" value="na">
                                    <label class="btn btn-outline-secondary" for="item{{ $item->id }}_na">
                                        N/A
                                    </label>
                                </div>
                            </div>
                            <textarea class="form-control fail-description" name="items[{{ $item->id }}][fail_description]" 
                                      rows="2" placeholder="Description (required if failed)"
                                      data-item="{{ $item->id }}" data-required="{{ $item->require_description_on_fail ? '1' : '0' }}"
                                      style="display: none;"></textarea>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Additional Information</h5>
        </div>
        <div class="card-body">
            <div class="mb-3">
                <label for="notes" class="form-label">Notes (Optional)</label>
                <textarea class="form-control" id="notes" name="notes" rows="3" 
                          placeholder="Any additional observations or comments..."></textarea>
            </div>

            <div class="mb-3">
                <label for="photos" class="form-label">Photos (Optional)</label>
                <input type="file" class="form-control" id="photos" name="photos[]" accept="image/*" multiple>
                <div class="form-text">You can upload multiple photos. Max 5MB per photo.</div>
            </div>
        </div>
    </div>

    <button type="submit" class="btn btn-primary btn-lg">
        <i class="bi bi-check-circle"></i> Submit Inspection
    </button>
</form>

@push('scripts')
<script>
document.querySelectorAll('input[type="radio"]').forEach(function(radio) {
    radio.addEventListener('change', function() {
        const itemId = this.name.match(/\[(\d+)\]/)[1];
        const textarea = document.querySelector(`textarea[data-item="${itemId}"]`);
        
        if (this.value === 'fail') {
            textarea.style.display = 'block';
        } else {
            textarea.style.display = 'none';
        }
    });
});
</script>
@endpush
@endsection
