@extends('layouts.app')

@section('title', 'Settings')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-gear"></i> Settings</h2>
</div>

<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.settings.update') }}" method="POST">
            @csrf

            <div class="mb-3">
                <label for="company_name" class="form-label">Company Name</label>
                <input type="text" class="form-control @error('company_name') is-invalid @enderror" 
                       id="company_name" name="company_name" value="{{ old('company_name', $settings['company_name']) }}">
                @error('company_name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="safety_manager_email" class="form-label">Safety Manager Email</label>
                <input type="email" class="form-control @error('safety_manager_email') is-invalid @enderror" 
                       id="safety_manager_email" name="safety_manager_email" 
                       value="{{ old('safety_manager_email', $settings['safety_manager_email']) }}">
                <div class="form-text">Inspection reports will be sent to this email address.</div>
                @error('safety_manager_email')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="bi bi-check"></i> Save Settings
            </button>
        </form>
    </div>
</div>
@endsection
