<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Inspection Export</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f4f4f4; }
        .passed { color: green; }
        .failed { color: red; }
        h1 { margin-bottom: 5px; }
        .date { color: #666; font-size: 0.9em; }
    </style>
</head>
<body>
    <h1>Inspection Report</h1>
    <p class="date">Generated: {{ now()->format('M d, Y H:i:s') }}</p>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Date</th>
                <th>Worker</th>
                <th>Employee ID</th>
                <th>Equipment</th>
                <th>Tag ID</th>
                <th>Checklist</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($inspections as $inspection)
                <tr>
                    <td>{{ $inspection->id }}</td>
                    <td>{{ $inspection->inspection_date->format('Y-m-d H:i') }}</td>
                    <td>{{ $inspection->user->full_name }}</td>
                    <td>{{ $inspection->user->employee_id }}</td>
                    <td>{{ $inspection->equipment->name }}</td>
                    <td>{{ $inspection->equipment->tag_id }}</td>
                    <td>{{ $inspection->checklist->title }}</td>
                    <td class="{{ $inspection->overall_status }}">{{ ucfirst($inspection->overall_status) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
