@extends('layouts.app')

@section('title', 'Admin Dashboard')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-speedometer2"></i> Dashboard</h2>
</div>

<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="card card-stats primary">
            <div class="card-body">
                <h6 class="text-muted mb-2">Total Users</h6>
                <h3 class="mb-0">{{ $stats['total_users'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card card-stats warning">
            <div class="card-body">
                <h6 class="text-muted mb-2">Pending Approval</h6>
                <h3 class="mb-0">{{ $stats['pending_users'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card card-stats success">
            <div class="card-body">
                <h6 class="text-muted mb-2">Passed Inspections</h6>
                <h3 class="mb-0">{{ $stats['passed_inspections'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card card-stats danger">
            <div class="card-body">
                <h6 class="text-muted mb-2">Failed Inspections</h6>
                <h3 class="mb-0">{{ $stats['failed_inspections'] }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Recent Inspections</h5>
                <a href="{{ route('admin.inspections.index') }}" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            <div class="card-body">
                @if($recentInspections->isEmpty())
                    <p class="text-muted mb-0">No inspections yet.</p>
                @else
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Worker</th>
                                    <th>Equipment</th>
                                    <th>Checklist</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recentInspections as $inspection)
                                    <tr>
                                        <td>{{ $inspection->inspection_date->format('M d, H:i') }}</td>
                                        <td>{{ $inspection->user->full_name }}</td>
                                        <td>{{ $inspection->equipment->name }}</td>
                                        <td>{{ $inspection->checklist->title }}</td>
                                        <td>
                                            <span class="badge bg-{{ $inspection->getStatusClass() }}">
                                                {{ $inspection->getStatusLabel() }}
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Pending Users</h5>
                <a href="{{ route('admin.users.pending') }}" class="btn btn-sm btn-outline-warning">Review</a>
            </div>
            <div class="card-body">
                @if($pendingUsers->isEmpty())
                    <p class="text-muted mb-0">No pending users.</p>
                @else
                    <ul class="list-group list-group-flush">
                        @foreach($pendingUsers as $user)
                            <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                                <div>
                                    <strong>{{ $user->full_name }}</strong>
                                    <br><small class="text-muted">{{ $user->department->name }}</small>
                                </div>
                                <span class="badge bg-warning">Pending</span>
                            </li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Overdue Inspections</h5>
            </div>
            <div class="card-body">
                @if($overdueEquipment->isEmpty())
                    <p class="text-muted mb-0">No overdue inspections.</p>
                @else
                    <ul class="list-group list-group-flush">
                        @foreach($overdueEquipment as $item)
                            <li class="list-group-item px-0">
                                <strong>{{ $item['equipment']->name }}</strong>
                                <br><small class="text-muted">{{ $item['checklist']->title }}</small>
                                <br><span class="badge bg-danger">{{ $item['days_overdue'] }} days overdue</span>
                            </li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
