@extends('layouts.app')

@section('title', 'Checklist: ' . $checklist->title)

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-list-check"></i> {{ $checklist->title }}</h2>
    <div>
        <a href="{{ route('admin.checklists.edit', $checklist) }}" class="btn btn-primary">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="{{ route('admin.checklists.index') }}" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Checklist Items</h5>
                <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addItemModal">
                    <i class="bi bi-plus"></i> Add Item
                </button>
            </div>
            <div class="card-body">
                @if($checklist->items->isEmpty())
                    <p class="text-muted">No items in this checklist.</p>
                @else
                    <div class="list-group">
                        @foreach($checklist->items as $item)
                            <div class="list-group-item">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h6 class="mb-1">{{ $item->item_name }}</h6>
                                        @if($item->description)
                                            <p class="mb-1 text-muted small">{{ $item->description }}</p>
                                        @endif
                                        @if($item->require_description_on_fail)
                                            <span class="badge bg-warning text-dark">Requires description on fail</span>
                                        @endif
                                    </div>
                                    <div>
                                        <form action="{{ route('admin.checklists.items.destroy', $item) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger" 
                                                    onclick="return confirm('Are you sure?')">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Description:</strong><br>{{ $checklist->description ?: 'N/A' }}</p>
                <p><strong>Frequency:</strong> {{ $checklist->frequency_days }} days</p>
                <p><strong>Status:</strong> 
                    <span class="badge {{ $checklist->is_active ? 'bg-success' : 'bg-secondary' }}">
                        {{ $checklist->is_active ? 'Active' : 'Inactive' }}
                    </span>
                </p>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">Assigned Equipment</h5>
            </div>
            <div class="card-body">
                @if($checklist->equipment->isEmpty())
                    <p class="text-muted mb-0">No equipment assigned.</p>
                @else
                    <ul class="list-unstyled mb-0">
                        @foreach($checklist->equipment as $equip)
                            <li><i class="bi bi-tools"></i> {{ $equip->name }} ({{ $equip->tag_id }})</li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Assigned Users</h5>
            </div>
            <div class="card-body">
                @if($checklist->users->isEmpty())
                    <p class="text-muted mb-0">No users assigned.</p>
                @else
                    <ul class="list-unstyled mb-0">
                        @foreach($checklist->users as $user)
                            <li><i class="bi bi-person"></i> {{ $user->full_name }}</li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="addItemModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.checklists.items.store', $checklist) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Add Checklist Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="item_name" class="form-label">Item Name</label>
                        <input type="text" class="form-control" id="item_name" name="item_name" required>
                    </div>
                    <div class="mb-3">
                        <label for="item_description" class="form-label">Description</label>
                        <textarea class="form-control" id="item_description" name="description" rows="2"></textarea>
                    </div>
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="require_description_on_fail" 
                               name="require_description_on_fail" value="1">
                        <label class="form-check-label" for="require_description_on_fail">
                            Require description when failed
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Item</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
