<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Equipment extends Model
{
    use HasFactory;

    protected $table = 'equipment';

    protected $fillable = [
        'name',
        'tag_id',
        'department_id',
        'location',
        'type',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function department(): BelongsTo
    {
        return $this->belongsTo(Department::class);
    }

    public function checklists(): BelongsToMany
    {
        return $this->belongsToMany(Checklist::class, 'checklist_equipment')
            ->withTimestamps();
    }

    public function inspections(): HasMany
    {
        return $this->hasMany(Inspection::class);
    }

    public function getTypeLabel(): string
    {
        return match($this->type) {
            'tool' => 'Tool',
            'forklift' => 'Forklift',
            'crane' => 'Crane',
            'vehicle' => 'Vehicle',
            'machinery' => 'Machinery',
            default => 'Other',
        };
    }
}
