@extends('layouts.app')

@section('title', 'Worker Dashboard')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-speedometer2"></i> Dashboard</h2>
    <a href="{{ route('worker.inspections.select-checklist') }}" class="btn btn-primary">
        <i class="bi bi-plus"></i> New Inspection
    </a>
</div>

<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="card card-stats primary">
            <div class="card-body">
                <h6 class="text-muted mb-2">Total Inspections</h6>
                <h3 class="mb-0">{{ $stats['total_inspections'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card card-stats warning">
            <div class="card-body">
                <h6 class="text-muted mb-2">This Month</h6>
                <h3 class="mb-0">{{ $stats['inspections_this_month'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card card-stats success">
            <div class="card-body">
                <h6 class="text-muted mb-2">Passed</h6>
                <h3 class="mb-0">{{ $stats['passed_inspections'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card card-stats danger">
            <div class="card-body">
                <h6 class="text-muted mb-2">Failed</h6>
                <h3 class="mb-0">{{ $stats['failed_inspections'] }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Recent Inspections</h5>
                <a href="{{ route('worker.inspections.index') }}" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            <div class="card-body">
                @if($recentInspections->isEmpty())
                    <p class="text-muted mb-0">No inspections yet. Start your first inspection!</p>
                @else
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Equipment</th>
                                    <th>Checklist</th>
                                    <th>Status</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recentInspections as $inspection)
                                    <tr>
                                        <td>{{ $inspection->inspection_date->format('M d, H:i') }}</td>
                                        <td>{{ $inspection->equipment->name }}</td>
                                        <td>{{ $inspection->checklist->title }}</td>
                                        <td>
                                            <span class="badge bg-{{ $inspection->getStatusClass() }}">
                                                {{ $inspection->getStatusLabel() }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('worker.inspections.show', $inspection) }}" 
                                               class="btn btn-sm btn-outline-info">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Assigned Checklists</h5>
            </div>
            <div class="card-body">
                @if($assignedChecklists->isEmpty())
                    <p class="text-muted mb-0">No checklists assigned yet.</p>
                @else
                    <div class="list-group list-group-flush">
                        @foreach($assignedChecklists as $checklist)
                            <a href="{{ route('worker.inspections.select-equipment', $checklist) }}" 
                               class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>{{ $checklist->title }}</strong>
                                    <br><small class="text-muted">{{ $checklist->items_count }} items</small>
                                </div>
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
