<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckApproved
{
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->check() && !auth()->user()->isApproved()) {
            auth()->logout();
            return redirect()->route('login')
                ->with('error', 'Your account is pending approval. Please wait for an administrator to approve your account.');
        }

        return $next($request);
    }
}
